'use strict';

/**
 * Objeto Oficina de Tecnologias de la Informacion UNSM
 * Maneja la funcionalidad especifica de la pagina de OTI
 */
const OficinaTI = {
    // ============================================
    // ESTADO DE LA APLICACION
    // ============================================
    state: {
        currentTab: 'funciones'
    },

    // ============================================
    // INICIALIZACION
    // ============================================
    init() {
        try {
            console.log('========================================');
            console.log('= INICIANDO MODULO OFICINA DE TI');
            console.log('========================================');

            this.initTabs();
            console.log(' Sistema de tabs inicializado');

            console.log('========================================');
            console.log(' MODULO OFICINA DE TI CARGADO');
            console.log('========================================');
        } catch (error) {
            console.error(' Error durante la inicializacion de Oficina de TI:', error);
        }
    },

    // ============================================
    // SISTEMA DE TABS
    // ============================================
    initTabs() {
        const tabButtons = document.querySelectorAll('.tab-button');
        const tabContents = document.querySelectorAll('.tab-content');

        if (tabButtons.length === 0) {
            console.warn(' No se encontraron botones de tabs');
            return;
        }

        tabButtons.forEach(button => {
            button.addEventListener('click', (e) => {
                e.preventDefault();
                const targetTab = button.getAttribute('data-tab');
                this.switchTab(targetTab, tabButtons, tabContents);
            });
        });
    },

    switchTab(targetTab, tabButtons, tabContents) {
        // Actualizar estado
        this.state.currentTab = targetTab;

        // Remover clase active de todos los botones
        tabButtons.forEach(btn => {
            btn.classList.remove('active');
            btn.setAttribute('aria-selected', 'false');
        });

        // Remover clase active de todos los contenidos
        tabContents.forEach(content => {
            content.classList.remove('active');
        });

        // Agregar clase active al boton seleccionado
        const activeButton = document.querySelector(`[data-tab="${targetTab}"]`);
        if (activeButton) {
            activeButton.classList.add('active');
            activeButton.setAttribute('aria-selected', 'true');
        }

        // Agregar clase active al contenido correspondiente
        const activeContent = document.getElementById(targetTab);
        if (activeContent) {
            activeContent.classList.add('active');
        }

        console.log(`= Tab cambiado a: ${targetTab}`);
    }
};

// ============================================
// INICIALIZACION AL CARGAR EL DOM
// ============================================
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', () => OficinaTI.init());
} else {
    OficinaTI.init();
}

// ============================================
// MANEJO DE ERRORES ESPECIFICO DEL MODULO
// ============================================
window.addEventListener('error', (event) => {
    if (event.filename && event.filename.includes('scriptOTI.js')) {
        console.error(' Error en modulo Oficina de TI:', event.error);
    }
});

// ============================================
// EXPORTAR PARA USO EN MODULOS (OPCIONAL)
// ============================================
if (typeof module !== 'undefined' && module.exports) {
    module.exports = OficinaTI;
}
